/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import com.medset.graphics.PadsyFont;
import com.medset.graphics.TableLayout;
import com.medset.padsy.PadsyImages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class PadsyTitlePane
extends JComponent {
    private static final int CLOSE_ICON_SIZE = 12;
    private static final int SYSTEM_ICON_HEIGHT = 16;
    private static final int SYSTEM_ICON_WIDTH = 16;
    private static final long serialVersionUID = 4937022807388622207L;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final Color ERROR_COLOR_START = new Color(157, 59, 67);
    private static final Color ERROR_COLOR_END = new Color(199, 27, 27);
    private static final Color BLUE_COLOR_START = new Color(33, 120, 157);
    private static final Color BLUE_COLOR_END = new Color(130, 191, 217);
    private static final Color WARNING_COLOR_START = new Color(212, 125, 35);
    private static final Color WARNING_COLOR_END = new Color(234, 184, 12);
    private static final Color ERROR_COLOR_LINE = new Color(158, 0, 8);
    private static final Color WHITE_COLOR_LINE = Color.WHITE;
    private static final Color WARNING_COLOR_LINE = new Color(224, 110, 0);
    private static final Color BLUE_COLOR_LINE = new Color(36, 128, 166);
    private static final Icon CLOSE_BUTTON_NORMAL = PadsyImages.getScaledImageIcon("svg/Close_Normal.svg", 12, 12);
    private static final Icon CLOSE_BUTTON_ROLLOVER = PadsyImages.getScaledImageIcon("svg/Close_Rollover.svg", 12, 12);
    private static final Icon CLOSE_BUTTON_PRESSED = PadsyImages.getScaledImageIcon("svg/Close_Pressed.svg", 12, 12);
    private PropertyChangeListener propertyChangeListener;
    private WindowListener windowListener;
    private Window window;
    private Icon systemIcon = PadsyImages.getImageIcon("PADSY32.PNG");
    private JRootPane rootPane;
    private int state;
    private JLabel titleLabel;

    public PadsyTitlePane(JRootPane root) {
        this.rootPane = root;
        this.state = -1;
        int topBottomBorder = 7;
        int leftBorder = 14;
        this.setLayout(new TableLayout(new double[]{leftBorder, -1.0, -2.0, leftBorder}, new double[]{topBottomBorder, -2.0, topBottomBorder}));
        this.titleLabel = new JLabel(this.getTitle(), 2);
        this.titleLabel.setFont(PadsyFont.getBoldFont(17.0f));
        this.titleLabel.setForeground(Color.WHITE);
        this.add((Component)this.titleLabel, "1,1");
        if (!this.isOptionPane()) {
            this.titleLabel.setIcon(this.systemIcon);
            this.titleLabel.setIconTextGap(6);
            JRadioButton closeButton = new JRadioButton(new CloseAction());
            closeButton.setIcon(CLOSE_BUTTON_NORMAL);
            closeButton.setPressedIcon(CLOSE_BUTTON_PRESSED);
            closeButton.setRolloverIcon(CLOSE_BUTTON_ROLLOVER);
            closeButton.setOpaque(false);
            this.add((Component)closeButton, "2,1");
        }
    }

    private boolean isOptionPane() {
        int style = this.getWindowDecorationStyle();
        return style == 4 || style == 8 || style == 3 || style == 7;
    }

    @Override
    public Dimension getPreferredSize() {
        int height = 34;
        return new Dimension(this.rootPane.getWidth(), height);
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            if (this.window.isActive()) {
                this.getRootPane().repaint();
            }
            this.installListeners();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private Paint getTitleColor() {
        GradientPaint retval = null;
        GradientPaint blueGradient = new GradientPaint(0.0f, 0.0f, BLUE_COLOR_START, 0.0f, this.getHeight(), BLUE_COLOR_END);
        switch (this.getWindowDecorationStyle()) {
            case 4: {
                retval = new GradientPaint(0.0f, 0.0f, ERROR_COLOR_START, 0.0f, this.getHeight(), ERROR_COLOR_END);
                break;
            }
            case 7: {
                retval = blueGradient;
                break;
            }
            case 8: {
                retval = new GradientPaint(0.0f, 0.0f, WARNING_COLOR_START, 0.0f, this.getHeight(), WARNING_COLOR_END);
                break;
            }
            case 2: {
                retval = blueGradient;
                break;
            }
            case 3: {
                retval = blueGradient;
                break;
            }
            default: {
                retval = blueGradient;
            }
        }
        return retval;
    }

    protected Color getSeparatorColor() {
        Color retval = null;
        switch (this.getWindowDecorationStyle()) {
            case 4: {
                retval = ERROR_COLOR_LINE;
                break;
            }
            case 7: {
                retval = BLUE_COLOR_LINE;
                break;
            }
            case 8: {
                retval = WARNING_COLOR_LINE;
                break;
            }
            case 2: {
                retval = BLUE_COLOR_LINE;
                break;
            }
            case 3: {
                retval = BLUE_COLOR_LINE;
                break;
            }
            default: {
                retval = BLUE_COLOR_LINE;
            }
        }
        return retval;
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            this.state = state;
        }
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        this.titleLabel.setText(this.getTitle());
        g2D.setPaint(this.getTitleColor());
        g2D.fillRect(0, 0, this.getWidth(), this.getHeight() - 2);
        g2D.setColor(this.getSeparatorColor());
        g2D.drawLine(0, this.getHeight() - 2, this.getWidth(), this.getHeight() - 2);
        g2D.setColor(WHITE_COLOR_LINE);
        g2D.drawLine(0, this.getHeight(), this.getWidth(), this.getHeight());
    }

    private class CloseAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Window window = PadsyTitlePane.this.getWindow();
            if (window != null) {
                window.dispatchEvent(new WindowEvent(window, 201));
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = PadsyTitlePane.this.getFrame();
                if (frame != null) {
                    PadsyTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    PadsyTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                PadsyTitlePane.this.repaint();
            } else if ("componentOrientation" == name) {
                PadsyTitlePane.this.revalidate();
                PadsyTitlePane.this.repaint();
            } else if ("iconImage" == name) {
                PadsyTitlePane.this.revalidate();
                PadsyTitlePane.this.repaint();
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            PadsyTitlePane.this.getRootPane().repaint();
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            PadsyTitlePane.this.getRootPane().repaint();
        }
    }
}

