/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public class PadsyToggleButtonUI
extends MetalToggleButtonUI {
    private Color col1 = new Color(255, 255, 255, 0);
    private Color col2 = new Color(255, 255, 255, 128);
    private Color col3 = new Color(0, 0, 0, 0);
    private Color col4 = new Color(0, 0, 0, 64);
    private static final boolean NO_3D_BUTTONS = Boolean.getBoolean("com.medset.plaf.no3d");
    private static Color DISABLE_COLOR = new Color(204, 204, 204);
    private static final PadsyToggleButtonUI buttonUI = new PadsyToggleButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return buttonUI;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!b.isSelected()) {
            b.setOpaque(false);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = b.getDisplayedMnemonicIndex();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (model.isEnabled()) {
            if (model.isSelected() || model.isPressed()) {
                g.setColor(Color.white);
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x + 1, textRect.y + fm.getAscent() + 1);
            } else {
                g.setColor(b.getForeground());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            }
        } else {
            g.setColor(this.getDisabledTextColor());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2D = (Graphics2D)g;
        if (!((AbstractButton)c).getModel().isEnabled()) {
            g2D.setColor(DISABLE_COLOR);
            Rectangle rec1 = new Rectangle(0, 0, c.getWidth(), c.getHeight());
            g2D.fill(rec1);
        }
        super.paint(g, c);
        if (!NO_3D_BUTTONS) {
            GradientPaint gradient1;
            if (((AbstractButton)c).getModel().isPressed()) {
                gradient1 = new GradientPaint(0.0f, (float)c.getHeight() / 2.0f, this.col3, 0.0f, 0.0f, this.col4);
                Rectangle rec1 = new Rectangle(0, 0, c.getWidth(), c.getHeight() / 2);
                g2D.setPaint(gradient1);
                g2D.fill(rec1);
                GradientPaint gradient2 = new GradientPaint(0.0f, (float)c.getHeight() / 2.0f, this.col1, 0.0f, c.getHeight(), this.col2);
                Rectangle rec2 = new Rectangle(0, c.getHeight() / 2, c.getWidth(), c.getHeight());
                g2D.setPaint(gradient2);
                g2D.fill(rec2);
            } else if (((AbstractButton)c).getModel().isEnabled()) {
                gradient1 = new GradientPaint(0.0f, (float)c.getHeight() / 2.0f, this.col1, 0.0f, 0.0f, this.col2);
                Rectangle rec1 = new Rectangle(0, 0, c.getWidth(), c.getHeight() / 2);
                g2D.setPaint(gradient1);
                g2D.fill(rec1);
                GradientPaint gradient2 = new GradientPaint(0.0f, (float)c.getHeight() / 2.0f, this.col3, 0.0f, c.getHeight(), this.col4);
                Rectangle rec2 = new Rectangle(0, c.getHeight() / 2, c.getWidth(), c.getHeight());
                g2D.setPaint(gradient2);
                g2D.fill(rec2);
            }
        }
    }
}

