/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import com.medset.graphics.MedsetColor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalToolTipUI;

public class PadsyToolTipUI
extends MetalToolTipUI {
    private static final int SPACE = 5;

    @Override
    public void installUI(JComponent c) {
        JToolTip toolTip = (JToolTip)c;
        toolTip.setBorder(null);
        toolTip.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        FontMetrics metrics = c.getFontMetrics(c.getFont());
        Graphics2D g2D = (Graphics2D)g;
        Composite oldComposite = g2D.getComposite();
        Color oldColor = g2D.getColor();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AlphaComposite instance = AlphaComposite.getInstance(3, 0.5f);
        g2D.setComposite(instance);
        g2D.setColor(MedsetColor.MEDSET_NORMAL);
        Dimension toolTipSize = c.getSize();
        g2D.fill(new RoundRectangle2D.Double(0.0, 0.0, toolTipSize.getWidth(), toolTipSize.getHeight(), 11.0, 11.0));
        g2D.setComposite(oldComposite);
        g2D.setColor(Color.BLACK);
        g2D.drawString(((JToolTip)c).getTipText(), 5, c.getY() + metrics.getHeight() + 5 - metrics.getDescent());
        g2D.setColor(oldColor);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        FontMetrics metrics = c.getFontMetrics(c.getFont());
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        int width = SwingUtilities.computeStringWidth(metrics, tipText);
        int height = metrics.getHeight();
        return new Dimension(width + 10, height + 10);
    }
}

