/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.plaf.basic.BasicArrowButton;

public class SimpleArrowButton
extends BasicArrowButton {
    static final int ARROW_HEIGHT = 7;
    private static final long serialVersionUID = -7894733613166161856L;
    static final int ARROW_WIDTH = 8;
    private GeneralPath triangleShape;

    public SimpleArrowButton(int direction) {
        super(direction);
        this.setOpaque(false);
    }

    @Override
    public void paint(Graphics g) {
        this.paintTriangle(g, (this.getWidth() - 8) / 2, (this.getHeight() - 7) / 2, 8, this.getDirection(), true);
    }

    @Override
    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        if (direction == 5) {
            Graphics2D g2d = null;
            try {
                g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                this.triangleShape = new GeneralPath();
                this.triangleShape.moveTo(x, y);
                this.triangleShape.lineTo(x + size, y);
                this.triangleShape.lineTo(x + size / 2, y + 7);
                this.triangleShape.lineTo(x, y);
                g2d.setColor(Color.BLACK);
                g2d.fill(this.triangleShape);
            }
            finally {
                if (g2d != null) {
                    g2d.dispose();
                }
            }
        } else {
            super.paintTriangle(g, x, y, size, direction, isEnabled);
        }
    }

    public Shape getTriangleShape() {
        return this.triangleShape;
    }
}

